<?php
define('DEPTH', 1);
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/layout.php';

if (!isActivated()) { header('Location: ../activate.php'); exit; }
$user = currentUser();
if (!$user || $user['role'] !== 'admin') { header('Location: ../index.php'); exit; }

$lang      = getLang();
$sys       = json_decode(file_get_contents(SYSTEM_FILE), true) ?? [];
$churchId  = 'main';
$church    = ['name' => $sys['church_name'] ?? 'Eklesia'];

$members     = getChurchMembers($churchId);
$subs        = getSubdivisions($churchId);
$leaders     = getLeaders($churchId);
$ministries  = getMinistries($churchId);
$blacklist   = getBlacklist($churchId);
$finances    = getFinances($churchId);

$total    = count($members['members'] ?? []);
$activos  = array_filter($members['members'] ?? [], fn($m) => ($m['status'] ?? '') === 'active');
$cortados = array_filter($members['members'] ?? [], fn($m) => ($m['status'] ?? '') === 'suspended');

$totalIncome  = array_sum(array_column(array_filter($finances['transactions'] ?? [], fn($t) => ($t['type'] ?? '') === 'income'), 'amount'));
$totalExpense = array_sum(array_column(array_filter($finances['transactions'] ?? [], fn($t) => ($t['type'] ?? '') === 'expense'), 'amount'));

$title = $lang==='en' ? 'Dashboard' : 'Painel';
renderHead($title);
?>
<body>
<?php renderSidebar('admin'); ?>
<div class="main-content">
    <div class="topbar">
        <div style="display:flex;align-items:center;gap:1rem">
            <button class="hamburger" onclick="toggleSidebar()"><span></span><span></span><span></span></button>
            <div>
                <div class="topbar-title"><?= htmlspecialchars($sys['church_name'] ?? 'Eklesia') ?></div>
                <div class="topbar-sub"><?= $lang==='en'?'Dashboard':'Painel de Controlo' ?></div>
            </div>
        </div>
        <div class="topbar-actions">
            <a href="../church/setup.php" class="btn btn-outline btn-sm">⚙️ <?= $lang==='en'?'Settings':'Config.' ?></a>
        </div>
    </div>
    <div class="page-content">
        <?php renderSuggestionBanner(); ?>
        <?php renderFlash(); ?>

        <!-- Stats -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon">👥</div>
                <div class="stat-info">
                    <div class="stat-value"><?= $total ?></div>
                    <div class="stat-label"><?= $lang==='en'?'Total Members':'Total Membros' ?></div>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon">✅</div>
                <div class="stat-info">
                    <div class="stat-value" style="color:var(--success)"><?= count($activos) ?></div>
                    <div class="stat-label"><?= $lang==='en'?'Active':'Activos' ?></div>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon">⛪</div>
                <div class="stat-info">
                    <div class="stat-value"><?= count($subs['subdivisions'] ?? []) ?></div>
                    <div class="stat-label"><?= $lang==='en'?'Congregations':'Congregações' ?></div>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon">💰</div>
                <div class="stat-info">
                    <div class="stat-value" style="color:var(--gold);font-size:1.4rem">
                        <?= number_format($totalIncome - $totalExpense, 2) ?>
                    </div>
                    <div class="stat-label"><?= $lang==='en'?'Balance':'Saldo' ?></div>
                </div>
            </div>
        </div>

        <!-- Quick links -->
        <div class="responsive-2col">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">🚀 <?= $lang==='en'?'Quick Access':'Acesso Rápido' ?></h3>
                </div>
                <div class="card-body" style="display:grid;grid-template-columns:1fr 1fr;gap:.75rem">
                    <a href="../church/members.php" class="btn btn-outline btn-sm">👥 <?= $lang==='en'?'Members':'Membros' ?></a>
                    <a href="../church/members.php?action=new" class="btn btn-primary btn-sm">＋ <?= $lang==='en'?'New Member':'Novo Membro' ?></a>
                    <a href="../finance/" class="btn btn-outline btn-sm">💰 <?= $lang==='en'?'Finances':'Finanças' ?></a>
                    <a href="../church/reports.php" class="btn btn-outline btn-sm">📊 <?= $lang==='en'?'Reports':'Relatórios' ?></a>
                    <a href="../church/setup.php" class="btn btn-outline btn-sm">⚙️ <?= $lang==='en'?'Settings':'Config.' ?></a>
                    <a href="../church/users.php" class="btn btn-outline btn-sm">👤 <?= $lang==='en'?'Users':'Utilizadores' ?></a>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">📋 <?= $lang==='en'?'Recent Activity':'Actividade Recente' ?></h3>
                </div>
                <div class="card-body">
                    <?php
                    $recent = array_slice(array_reverse($members['members'] ?? []), 0, 5);
                    if (empty($recent)): ?>
                    <div class="empty-state" style="padding:1rem">
                        <div class="empty-icon">👥</div>
                        <p><?= $lang==='en'?'No members yet. Add the first one!':'Sem membros ainda. Adicione o primeiro!' ?></p>
                    </div>
                    <?php else: ?>
                    <?php foreach ($recent as $m): ?>
                    <div style="display:flex;align-items:center;gap:.65rem;padding:.5rem 0;border-bottom:1px solid var(--border)">
                        <div class="member-avatar"><?= strtoupper(substr($m['name'],0,1)) ?></div>
                        <div>
                            <div style="font-size:.85rem;font-weight:600;color:var(--text)"><?= htmlspecialchars($m['name']) ?></div>
                            <div class="text-xs text-muted"><?= htmlspecialchars($m['city'] ?? '') ?> · <?= $m['created_at'] ?? '' ?></div>
                        </div>
                        <?php $s=$m['status']??'active';
                              $badge = $s==='active'?'badge-success':($s==='suspended'?'badge-warning':'badge-grey'); ?>
                        <span class="badge <?= $badge ?>" style="margin-left:auto;font-size:.65rem"><?= htmlspecialchars($s) ?></span>
                    </div>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Líderes e subdivisões -->
        <div class="responsive-2col" style="margin-top:1.5rem">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">👑 <?= $lang==='en'?'Leaders':'Líderes' ?></h3>
                    <span class="badge badge-gold"><?= count($leaders['leaders'] ?? []) ?></span>
                </div>
                <?php $ls = array_slice($leaders['leaders'] ?? [], 0, 5); ?>
                <?php if (empty($ls)): ?>
                <div class="empty-state" style="padding:1.5rem">
                    <p><?= $lang==='en'?'No leaders defined.':'Sem líderes definidos.' ?></p>
                    <a href="../church/leaders.php" class="btn btn-outline btn-sm" style="margin-top:.5rem"><?= $lang==='en'?'Add Leaders':'Gerir Líderes' ?></a>
                </div>
                <?php else: ?>
                <div style="padding:1rem">
                    <?php foreach ($ls as $l): ?>
                    <div style="display:flex;align-items:center;gap:.65rem;padding:.45rem 0;border-bottom:1px solid var(--border)">
                        <div class="member-avatar"><?= strtoupper(substr(getMemberName($churchId, $l['member_id']),0,1)) ?></div>
                        <div style="flex:1">
                            <div style="font-size:.85rem;font-weight:600"><?= htmlspecialchars(getMemberName($churchId, $l['member_id'])) ?></div>
                            <div class="text-xs text-muted"><?= htmlspecialchars($l['role'] ?? 'Líder') ?></div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">🏛️ <?= $lang==='en'?'Congregations':'Subdivisões' ?></h3>
                    <a href="../church/setup.php#subdivisions" class="btn btn-outline btn-sm">＋</a>
                </div>
                <?php $ssubs = $subs['subdivisions'] ?? []; ?>
                <?php if (empty($ssubs)): ?>
                <div class="empty-state" style="padding:1.5rem">
                    <p><?= $lang==='en'?'No congregations yet.':'Sem subdivisões ainda.' ?></p>
                </div>
                <?php else: ?>
                <div class="table-wrap">
                    <table><thead><tr><th><?= $lang==='en'?'Name':'Nome' ?></th><th><?= $lang==='en'?'Location':'Local' ?></th></tr></thead><tbody>
                    <?php foreach ($ssubs as $s): ?>
                    <tr>
                        <td style="font-weight:600"><?= htmlspecialchars($s['name']) ?></td>
                        <td class="text-muted text-sm"><?= htmlspecialchars($s['location'] ?? '—') ?></td>
                    </tr>
                    <?php endforeach; ?>
                    </tbody></table>
                </div>
                <?php endif; ?>
            </div>
        </div>

    </div>
    <?php renderFooter(); ?>
</div>
<?php renderJS(); ?>
