<?php
define('DEPTH', 1);
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';

$user = currentUser();
if (!$user || $user['role'] !== 'church_admin') { header('Location: ../index.php'); exit; }

$churchId    = $user['church_id'];
$church      = getChurchInfo($churchId);
$membersData = getMembers($churchId);
$blacklist   = getBlacklist($churchId);
$subsData    = getSubdivisions($churchId);
$leaders     = getLeaders($churchId);
$ministries  = getMinistries($churchId);
$finance     = getFinance($churchId);

$members  = $membersData['members'];
$total    = count($members);
$activos  = array_values(array_filter($members, fn($m) => $m['status']==='activo'));
$cortados = array_values(array_filter($members, fn($m) => $m['status']==='cortado'));
$desvinc  = array_values(array_filter($members, fn($m) => $m['status']==='desvinculado'));
$casados  = array_values(array_filter($members, fn($m) => ($m['marital_status']??'') === 'casado'));
$solteiros= array_values(array_filter($members, fn($m) => ($m['marital_status']??'') === 'solteiro'));
$namorando= array_values(array_filter($members, fn($m) => !empty($m['dating_with'])));

$thisMonth = date('Y-m');
$novos = array_values(array_filter($members, fn($m) => str_starts_with($m['created_at']??'', $thisMonth)));

// Estatísticas financeiras
$transactions = $finance['transactions'] ?? [];
$totalEntradas= calcTotals($transactions, 'entrada');
$totalSaidas  = calcTotals($transactions, 'saida');

renderHead('Relatórios — ' . $church['name']);
?>
<body>
<?php renderSidebar($user['role']); ?>
<div class="main-content">
    <div class="topbar">
        <div><div class="topbar-title">Relatórios Locais</div><div class="topbar-sub"><?= sanitize($church['name']) ?></div></div>
        <div class="topbar-actions"><button onclick="window.print()" class="btn btn-outline btn-sm">🖨️ Imprimir / PDF</button></div>
    </div>
    <div class="page-content">
        <?php renderSuggestionBanner(); ?>

        <!-- Cabeçalho do Relatório -->
        <div class="card" style="margin-bottom:1.5rem;background:linear-gradient(135deg,var(--gold-pale),#fff);border-color:rgba(201,168,76,0.25)">
            <div style="padding:1.5rem;text-align:center">
                <div style="font-size:1.5rem;font-weight:800;color:var(--navy)"><?= sanitize($church['name']) ?></div>
                <div style="color:var(--text-sub);font-size:0.85rem;margin-top:0.3rem">Relatório Geral — <?= date('d/m/Y') ?></div>
            </div>
        </div>

        <!-- Membros -->
        <div class="card" style="margin-bottom:1.5rem">
            <div class="card-header"><h3 class="card-title">📊 Membresia</h3></div>
            <div class="stats-grid" style="grid-template-columns:repeat(4,1fr);padding:1.5rem">
                <div class="stat-card"><div class="stat-info"><div class="stat-value"><?= $total ?></div><div class="stat-label">Total</div></div></div>
                <div class="stat-card"><div class="stat-info"><div class="stat-value" style="color:#22c55e"><?= count($activos) ?></div><div class="stat-label">Activos</div></div></div>
                <div class="stat-card"><div class="stat-info"><div class="stat-value" style="color:#f59e0b"><?= count($cortados) ?></div><div class="stat-label">Cortados</div></div></div>
                <div class="stat-card"><div class="stat-info"><div class="stat-value" style="color:#ef4444"><?= count($desvinc) ?></div><div class="stat-label">Desvinculados</div></div></div>
                <div class="stat-card"><div class="stat-info"><div class="stat-value"><?= count($casados) ?></div><div class="stat-label">Casados</div></div></div>
                <div class="stat-card"><div class="stat-info"><div class="stat-value"><?= count($solteiros) ?></div><div class="stat-label">Solteiros</div></div></div>
                <div class="stat-card"><div class="stat-info"><div class="stat-value"><?= count($namorando) ?></div><div class="stat-label">Em Namoro</div></div></div>
                <div class="stat-card"><div class="stat-info"><div class="stat-value" style="color:#c9a84c"><?= count($novos) ?></div><div class="stat-label">Novos/Mês</div></div></div>
            </div>
        </div>

        <!-- Por Subdivisão -->
        <?php if (!empty($subsData['subdivisions'])): ?>
        <div class="card" style="margin-bottom:1.5rem">
            <div class="card-header"><h3 class="card-title">🏘️ Por Subdivisão</h3></div>
            <div class="table-wrap">
                <table><thead><tr><th>Subdivisão</th><th>Total</th><th>Activos</th><th>Cortados</th><th>Desvinc.</th></tr></thead><tbody>
                <?php foreach ($subsData['subdivisions'] as $s):
                    $sm = array_filter($members, fn($m) => ($m['subdivision_id']??'') === $s['id']);
                    $sa = count(array_filter($sm, fn($m) => $m['status']==='activo'));
                    $sc = count(array_filter($sm, fn($m) => $m['status']==='cortado'));
                    $sd = count(array_filter($sm, fn($m) => $m['status']==='desvinculado'));
                ?>
                <tr>
                    <td><strong><?= sanitize($s['name']) ?></strong><div class="text-xs text-muted"><?= sanitize($s['type']??'') ?></div></td>
                    <td><span class="badge badge-gold"><?= count($sm) ?></span></td>
                    <td style="color:#22c55e;font-weight:600"><?= $sa ?></td>
                    <td style="color:#f59e0b;font-weight:600"><?= $sc ?></td>
                    <td style="color:#ef4444;font-weight:600"><?= $sd ?></td>
                </tr>
                <?php endforeach; ?>
                </tbody></table>
            </div>
        </div>
        <?php endif; ?>

        <!-- Membros Cortados com Histórico -->
        <?php if (!empty($cortados)): ?>
        <div class="card" style="margin-bottom:1.5rem">
            <div class="card-header"><h3 class="card-title">🔶 Histórico de Cortes</h3><span class="badge badge-warning"><?= count($cortados) ?></span></div>
            <div class="table-wrap">
                <table><thead><tr><th>Membro</th><th>Motivo Actual</th><th>Nº de Cortes</th><th>Nº Devoluções</th></tr></thead><tbody>
                <?php foreach ($cortados as $m):
                    $cuts = count(array_filter($m['cut_history']??[], fn($h) => $h['type']==='cortado'));
                    $devs = count(array_filter($m['cut_history']??[], fn($h) => $h['type']==='devolvido'));
                ?>
                <tr>
                    <td><strong><?= sanitize($m['name']) ?></strong></td>
                    <td class="text-sm text-muted"><?= sanitize($m['status_reason'] ?? '—') ?></td>
                    <td><span class="badge badge-warning"><?= $cuts ?>×</span></td>
                    <td><span class="badge badge-success"><?= $devs ?>×</span></td>
                </tr>
                <?php endforeach; ?>
                </tbody></table>
            </div>
        </div>
        <?php endif; ?>

        <!-- Financeiro -->
        <div class="card" style="margin-bottom:1.5rem">
            <div class="card-header"><h3 class="card-title">💰 Resumo Financeiro</h3></div>
            <div class="stats-grid" style="grid-template-columns:repeat(3,1fr);padding:1.5rem">
                <div class="stat-card"><div class="stat-info"><div class="stat-value" style="color:#22c55e"><?= number_format($totalEntradas,2,',','.') ?> MT</div><div class="stat-label">Total Entradas</div></div></div>
                <div class="stat-card"><div class="stat-info"><div class="stat-value" style="color:#ef4444"><?= number_format($totalSaidas,2,',','.') ?> MT</div><div class="stat-label">Total Saídas</div></div></div>
                <div class="stat-card"><div class="stat-info"><div class="stat-value" style="color:<?= ($totalEntradas-$totalSaidas)>=0?'#22c55e':'#ef4444' ?>"><?= number_format($totalEntradas-$totalSaidas,2,',','.') ?> MT</div><div class="stat-label">Saldo</div></div></div>
            </div>
        </div>

        <!-- Líderes e Ministérios -->
        <div style="display:grid;grid-template-columns:1fr 1fr;gap:1.5rem" class="responsive-2col">
            <div class="card">
                <div class="card-header"><h3 class="card-title">👑 Líderes</h3><span class="badge badge-gold"><?= count($leaders['leaders']) ?></span></div>
                <?php if (empty($leaders['leaders'])): ?>
                <div class="empty-state" style="padding:1.5rem"><p style="color:var(--text-muted)">Sem líderes.</p></div>
                <?php else: ?>
                <div class="table-wrap"><table><thead><tr><th>Membro</th><th>Cargo</th></tr></thead><tbody>
                <?php foreach ($leaders['leaders'] as $l): ?>
                <tr><td><?= sanitize(getMemberName($churchId, $l['member_id'])) ?></td><td class="text-sm"><?= sanitize($l['role']??'—') ?></td></tr>
                <?php endforeach; ?>
                </tbody></table></div>
                <?php endif; ?>
            </div>
            <div class="card">
                <div class="card-header"><h3 class="card-title">✝️ Ministérios</h3><span class="badge badge-gold"><?= count($ministries['assignments']) ?></span></div>
                <?php if (empty($ministries['assignments'])): ?>
                <div class="empty-state" style="padding:1.5rem"><p style="color:var(--text-muted)">Sem consagrações.</p></div>
                <?php else: ?>
                <div class="table-wrap"><table><thead><tr><th>Membro</th><th>Ministério</th></tr></thead><tbody>
                <?php foreach ($ministries['assignments'] as $a):
                    $mtype = '';
                    foreach ($ministries['types'] as $t) { if ($t['id']===$a['ministry_id']) { $mtype=$t['name']; break; } }
                ?>
                <tr><td><?= sanitize(getMemberName($churchId, $a['member_id'])) ?></td><td class="text-sm"><?= sanitize($mtype) ?></td></tr>
                <?php endforeach; ?>
                </tbody></table></div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php renderFooter(); ?>
<?php renderJS(); ?>
<style>@media print { .sidebar,.topbar,.hamburger,.sidebar-overlay { display:none!important; } .main-content { margin:0!important; } }</style>
</body></html>
