<?php
define('DEPTH', 1);
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';
$user = currentUser();
if (!$user || $user['role'] !== 'finance_user') { header('Location: ../index.php'); exit; }
$churchId = 'main';
$church   = getChurchInfo($churchId);
$finance  = getFinance($churchId);

renderHead('Categorias — ' . $church['name']);
?>
<body>
<?php renderSidebar($user['role']); ?>
<div class="main-content">
    <div class="topbar">
        <div style="display:flex;align-items:center;gap:.85rem"><button class="hamburger" onclick="toggleSidebar()"><span></span><span></span><span></span></button><div><div class="topbar-title">Categorias Financeiras</div><div class="topbar-sub"><?= sanitize($church['name']) ?></div></div></div>
        <div class="topbar-actions"><button class="btn btn-primary btn-sm" data-modal="modal-cat">＋ Nova Categoria</button></div>
    </div>
    <div class="page-content">
        <?php renderSuggestionBanner(); ?>
        <?php renderFlash(); ?>
        <div class="card">
            <div class="card-header"><h3 class="card-title">Categorias</h3><span class="badge badge-gold"><?= count($finance['categories'] ?? []) ?></span></div>
            <?php if (empty($finance['categories'])): ?>
            <div class="empty-state"><div class="empty-icon">🏷️</div><h3>Sem categorias</h3><p>Crie categorias para organizar os movimentos financeiros.</p></div>
            <?php else: ?>
            <div class="table-wrap">
                <table><thead><tr><th>Nome</th><th>Tipo</th></tr></thead><tbody>
                <?php foreach ($finance['categories'] as $c): ?>
                <tr>
                    <td><strong><?= sanitize($c['name']) ?></strong></td>
                    <td><span class="badge <?= $c['type']==='entrada' ? 'badge-success' : 'badge-danger' ?>"><?= $c['type']==='entrada' ? 'Entrada' : 'Saída' ?></span></td>
                </tr>
                <?php endforeach; ?>
                </tbody></table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<div class="modal-overlay" id="modal-cat">
    <div class="modal">
        <div class="modal-header"><h3 class="modal-title">Nova Categoria</h3><button class="modal-close">✕</button></div>
        <form method="POST" action="save.php">
            <input type="hidden" name="action" value="save_category">
            <div class="modal-body">
                <div class="form-group"><label>Nome da Categoria</label><input type="text" name="cat_name" class="form-control" required placeholder="ex: Dízimo, Oferta Especial, Água..."></div>
                <div class="form-group"><label>Tipo</label><select name="cat_type" class="form-control"><option value="entrada">Entrada (receita)</option><option value="saida">Saída (despesa)</option></select></div>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-outline modal-close">Cancelar</button><button type="submit" class="btn btn-primary">Criar Categoria</button></div>
        </form>
    </div>
</div>
<?php renderFooter(); ?>
<?php renderJS(); ?></body></html>
