<?php
define('DEPTH', 1);
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/layout.php';

if (!isActivated()) { header('Location: ../activate.php'); exit; }
$user = currentUser();
if (!$user || !in_array($user['role'], ['admin','finance_user'])) { header('Location: ../index.php'); exit; }

$lang      = getLang();
$churchId  = 'main';
$finances  = getFinances($churchId);
$cats      = getFinanceCategories($churchId);
$month     = $_GET['month'] ?? date('Y-m');

$txAll = $finances['transactions'] ?? [];
$txMonth = array_filter($txAll, fn($t) => str_starts_with($t['date'] ?? '', $month));

$income  = array_sum(array_column(array_filter($txMonth, fn($t) => $t['type']==='income'),  'amount'));
$expense = array_sum(array_column(array_filter($txMonth, fn($t) => $t['type']==='expense'), 'amount'));
$balance = $income - $expense;

// Meses disponíveis
$months = [];
foreach ($txAll as $t) {
    $m = substr($t['date'] ?? '', 0, 7);
    if ($m) $months[$m] = true;
}
$months[date('Y-m')] = true;
krsort($months);

renderHead($lang==='en'?'Finances':'Finanças');
?>
<body>
<?php renderSidebar($user['role']); ?>
<div class="main-content">
    <div class="topbar">
        <div style="display:flex;align-items:center;gap:1rem">
            <button class="hamburger" onclick="toggleSidebar()"><span></span><span></span><span></span></button>
            <div>
                <div class="topbar-title">💰 <?= $lang==='en'?'Finances':'Finanças' ?></div>
                <div class="topbar-sub"><?= $month ?></div>
            </div>
        </div>
        <div class="topbar-actions">
            <select onchange="location='?month='+this.value" class="form-control" style="width:auto;padding:.45rem .8rem;font-size:.82rem">
                <?php foreach ($months as $m => $_): ?>
                <option value="<?= $m ?>" <?= $m===$month?'selected':'' ?>><?= $m ?></option>
                <?php endforeach; ?>
            </select>
            <button class="btn btn-primary btn-sm" data-modal="modal-tx">＋ <?= $lang==='en'?'Record':'Registar' ?></button>
        </div>
    </div>
    <div class="page-content">
        <?php renderSuggestionBanner(); ?>
        <?php renderFlash(); ?>

        <div class="finance-summary">
            <div class="finance-box income">
                <div class="label"><?= $lang==='en'?'Income':'Entradas' ?></div>
                <div class="amount"><?= number_format($income, 2) ?></div>
            </div>
            <div class="finance-box expense">
                <div class="label"><?= $lang==='en'?'Expenses':'Saídas' ?></div>
                <div class="amount"><?= number_format($expense, 2) ?></div>
            </div>
            <div class="finance-box balance">
                <div class="label"><?= $lang==='en'?'Balance':'Saldo' ?></div>
                <div class="amount" style="color:<?= $balance>=0?'var(--success)':'var(--danger)' ?>"><?= number_format($balance, 2) ?></div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $lang==='en'?'Transactions':'Movimentos' ?> — <?= $month ?></h3>
                <a href="../finance/reports.php" class="btn btn-outline btn-sm">📊 <?= $lang==='en'?'Reports':'Relatórios' ?></a>
            </div>
            <?php if (empty($txMonth)): ?>
            <div class="empty-state"><div class="empty-icon">💰</div><h3><?= $lang==='en'?'No records this month':'Sem registos este mês' ?></h3><p><?= $lang==='en'?'Click "+ Record" to add the first transaction.':'Clique "＋ Registar" para adicionar.' ?></p></div>
            <?php else: ?>
            <div class="table-wrap">
                <table><thead><tr>
                    <th><?= $lang==='en'?'Date':'Data' ?></th>
                    <th><?= $lang==='en'?'Description':'Descrição' ?></th>
                    <th><?= $lang==='en'?'Category':'Categoria' ?></th>
                    <th><?= $lang==='en'?'Type':'Tipo' ?></th>
                    <th><?= $lang==='en'?'Amount':'Valor' ?></th>
                    <th></th>
                </tr></thead><tbody>
                <?php foreach (array_reverse(array_values($txMonth)) as $t): ?>
                <tr>
                    <td class="text-muted text-sm"><?= htmlspecialchars($t['date'] ?? '') ?></td>
                    <td style="font-weight:500"><?= htmlspecialchars($t['description'] ?? '') ?></td>
                    <td class="text-muted text-sm"><?= htmlspecialchars($t['category'] ?? '—') ?></td>
                    <td><?php if ($t['type']==='income'): ?>
                        <span class="badge badge-success">↑ <?= $lang==='en'?'Income':'Entrada' ?></span>
                        <?php else: ?>
                        <span class="badge badge-danger">↓ <?= $lang==='en'?'Expense':'Saída' ?></span>
                        <?php endif; ?></td>
                    <td style="font-weight:700;color:<?= $t['type']==='income'?'var(--success)':'var(--danger)' ?>">
                        <?= ($t['type']==='income'?'+':'-') . number_format($t['amount'] ?? 0, 2) ?>
                    </td>
                    <td>
                        <form method="POST" action="../finance/save.php" onsubmit="return confirm('<?= $lang==='en'?'Delete this record?':'Eliminar este registo?' ?>')">
                            <input type="hidden" name="action" value="delete_tx">
                            <input type="hidden" name="tx_id" value="<?= $t['id'] ?? '' ?>">
                            <button type="submit" class="btn btn-danger btn-sm">🗑️</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
                </tbody></table>
            </div>
            <?php endif; ?>
        </div>

    </div>
    <?php renderFooter(); ?>
</div>

<!-- Modal: Nova Transacção -->
<div class="modal-overlay" id="modal-tx">
    <div class="modal">
        <div class="modal-header">
            <h3 class="modal-title">💰 <?= $lang==='en'?'Record Transaction':'Registar Movimento' ?></h3>
            <button class="modal-close">✕</button>
        </div>
        <form method="POST" action="../finance/save.php">
            <input type="hidden" name="action" value="save_tx">
            <input type="hidden" name="redirect_month" value="<?= htmlspecialchars($month) ?>">
            <div class="modal-body">
                <div class="form-row">
                    <div class="form-group">
                        <label><?= $lang==='en'?'Type':'Tipo' ?> <span class="req">*</span></label>
                        <select name="tx_type" class="form-control" required>
                            <option value="income">↑ <?= $lang==='en'?'Income':'Entrada' ?></option>
                            <option value="expense">↓ <?= $lang==='en'?'Expense':'Saída' ?></option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?= $lang==='en'?'Date':'Data' ?> <span class="req">*</span></label>
                        <input type="date" name="tx_date" class="form-control" required value="<?= date('Y-m-d') ?>">
                    </div>
                </div>
                <div class="form-group">
                    <label><?= $lang==='en'?'Description':'Descrição' ?> <span class="req">*</span></label>
                    <input type="text" name="tx_description" class="form-control" required
                        placeholder="<?= $lang==='en'?'E.g. Sunday tithes':'Ex: Dízimos de domingo' ?>">
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label><?= $lang==='en'?'Amount':'Valor' ?> <span class="req">*</span></label>
                        <input type="number" name="tx_amount" class="form-control" required min="0.01" step="0.01" placeholder="0.00">
                    </div>
                    <div class="form-group">
                        <label><?= $lang==='en'?'Category':'Categoria' ?></label>
                        <select name="tx_category" class="form-control">
                            <option value="">— <?= $lang==='en'?'None':'Nenhuma' ?> —</option>
                            <?php foreach ($cats['categories'] ?? [] as $c): ?>
                            <option value="<?= htmlspecialchars($c['name']) ?>"><?= htmlspecialchars($c['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label><?= $lang==='en'?'Notes':'Notas' ?></label>
                    <textarea name="tx_notes" class="form-control" rows="2"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline modal-close"><?= $lang==='en'?'Cancel':'Cancelar' ?></button>
                <button type="submit" class="btn btn-primary"><?= $lang==='en'?'Save':'Guardar' ?></button>
            </div>
        </form>
    </div>
</div>

<?php renderJS(); ?>
