<?php
// ═══════════════════════════════════════════════════════════════
//  EKLESIA — Sistema de Idiomas (PT / EN)
// ═══════════════════════════════════════════════════════════════

function getLang(): string {
    if (isset($_GET['lang']) && in_array($_GET['lang'], ['pt','en'])) {
        $_SESSION['eklesia_lang'] = $_GET['lang'];
    }
    return $_SESSION['eklesia_lang'] ?? 'pt';
}

function __(string $key, array $vars = []): string {
    global $LANG;
    $str = $LANG[$key] ?? $key;
    foreach ($vars as $k => $v) $str = str_replace('{{'.$k.'}}', $v, $str);
    return $str;
}

function _e(string $key, array $vars = []): void {
    echo __($key, $vars);
}

$lang = getLang();

$LANG_PT = [
    // Nav / Geral
    'app_name'            => 'Eklesia',
    'tagline'             => 'Sistema de Gestão Eclesiástica para África',
    'login'               => 'Entrar',
    'logout'              => 'Sair',
    'register'            => 'Registar Denominação',
    'dashboard'           => 'Painel',
    'save'                => 'Guardar',
    'cancel'              => 'Cancelar',
    'delete'              => 'Eliminar',
    'edit'                => 'Editar',
    'back'                => 'Voltar',
    'actions'             => 'Acções',
    'search'              => 'Pesquisar...',
    'yes'                 => 'Sim',
    'no'                  => 'Não',
    'loading'             => 'A carregar...',
    'success'             => 'Sucesso',
    'error'               => 'Erro',
    'warning'             => 'Atenção',
    'lang_switch'         => 'English',
    'lang_code'           => 'en',

    // Login
    'login_title'         => 'Aceder ao Sistema',
    'login_welcome'       => 'Bem-vindo ao Eklesia',
    'login_subtitle'      => 'Entre com as suas credenciais',
    'email'               => 'Email',
    'password'            => 'Senha',
    'login_btn'           => 'Entrar no Sistema',
    'forgot_pass'         => 'Esqueceu a senha?',
    'no_account'          => 'Ainda não tem conta?',
    'login_error'         => 'Email ou senha incorrectos.',
    'session_expired'     => 'Sessão expirada. Faça login novamente.',
    'logged_out'          => 'Sessão terminada com sucesso.',

    // Registo
    'reg_title'           => 'Registar Denominação',
    'reg_subtitle'        => 'Crie a conta da sua denominação gratuitamente',
    'church_name'         => 'Nome da Denominação',
    'church_name_ph'      => 'ex: Igreja Evangélica de Moçambique',
    'admin_name'          => 'Nome do Administrador',
    'country'             => 'País',
    'province'            => 'Província / Estado',
    'district'            => 'Distrito / Cidade',
    'admin_email'         => 'Email do Administrador',
    'admin_pass'          => 'Senha',
    'confirm_pass'        => 'Confirmar Senha',
    'pass_hint'           => 'Mínimo 6 caracteres: letras, números e símbolo (ex: Igreja#1)',
    'reg_btn'             => 'Criar Conta Gratuita',
    'already_account'     => 'Já tem conta?',
    'trial_info'          => '✅ 6 meses gratuitos — Sem cartão de crédito',
    'reg_success'         => 'Denominação registada! Pode agora fazer login.',
    'err_required'        => 'Preencha todos os campos obrigatórios.',
    'err_email'           => 'Email inválido.',
    'err_pass_match'      => 'As senhas não coincidem.',
    'err_pass_weak'       => 'A senha deve ter pelo menos 6 caracteres, uma letra, um número e um símbolo.',
    'err_email_used'      => 'Este email já está em uso.',

    // Dashboard
    'total_members'       => 'Total de Membros',
    'active_members'      => 'Activos',
    'cut_members'         => 'Cortados',
    'unlinked_members'    => 'Desvinculados',
    'married'             => 'Casados',
    'dating'              => 'Em Namoro',
    'new_this_month'      => 'Novos Este Mês',
    'subdivisions'        => 'Subdivisões',
    'leaders'             => 'Líderes',
    'members'             => 'Membros',
    'add_member'          => '＋ Novo Membro',
    'all_statuses'        => 'Todos os estados',
    'all_subs'            => 'Todas as subdivisões',
    'blacklist'           => 'Lista Negra',
    'restore'             => '♻️ Restaurar',
    'recent_members'      => 'Membros Recentes',
    'view_all'            => 'Ver Todos →',

    // Licença / Trial
    'trial_active'        => 'Período de Teste',
    'trial_days_left'     => '{{days}} dias restantes',
    'trial_expired'       => 'Período de Teste Expirado',
    'license_active'      => 'Licença Activa',
    'license_expires'     => 'Expira em {{date}}',
    'upgrade_now'         => 'Adquirir Licença',
    'contact_admin'       => 'Contactar Administrador',

    // Menu lateral
    'nav_dashboard'       => 'Painel',
    'nav_setup'           => 'Denominações & Subdivisões',
    'nav_users'           => 'Utilizadores',
    'nav_members'         => 'Membros',
    'nav_ministries'      => 'Ministérios',
    'nav_leaders'         => 'Líderes',
    'nav_finance'         => 'Financeiro',
    'nav_reports'         => 'Relatórios',
    'nav_public'          => 'Página Pública',
    'nav_churches'        => 'Denominações',
    'nav_licenses'        => 'Licenças',

    // Admin geral
    'super_admin_title'   => 'Administrador Geral',
    'churches_registered' => 'Denominações Registadas',
    'gen_key'             => 'Gerar Chave',
    'key_1yr'             => '1 Ano ($10)',
    'key_2yr'             => '2 Anos ($15)',
    'key_3yr'             => '3 Anos ($20)',
    'key_trial'           => 'Trial (+6 meses)',
    'delete_church'       => 'Eliminar Denominação',
    'confirm_delete'      => 'Tem a certeza que quer eliminar esta denominação? Esta acção é irreversível.',

    // Cookies / Privacidade
    'cookie_msg'          => 'Usamos cookies para melhorar a sua experiência. Ao continuar, aceita a nossa ',
    'cookie_policy'       => 'Política de Cookies',
    'privacy_policy'      => 'Política de Privacidade',
    'cookie_accept'       => 'Aceitar',
    'cookie_decline'      => 'Recusar',
];

$LANG_EN = [
    'app_name'            => 'Eklesia',
    'tagline'             => 'Church Management System for Africa',
    'login'               => 'Sign In',
    'logout'              => 'Sign Out',
    'register'            => 'Register Denomination',
    'dashboard'           => 'Dashboard',
    'save'                => 'Save',
    'cancel'              => 'Cancel',
    'delete'              => 'Delete',
    'edit'                => 'Edit',
    'back'                => 'Back',
    'actions'             => 'Actions',
    'search'              => 'Search...',
    'yes'                 => 'Yes',
    'no'                  => 'No',
    'loading'             => 'Loading...',
    'success'             => 'Success',
    'error'               => 'Error',
    'warning'             => 'Warning',
    'lang_switch'         => 'Português',
    'lang_code'           => 'pt',

    'login_title'         => 'Sign In to System',
    'login_welcome'       => 'Welcome to Eklesia',
    'login_subtitle'      => 'Enter your credentials to continue',
    'email'               => 'Email',
    'password'            => 'Password',
    'login_btn'           => 'Sign In',
    'forgot_pass'         => 'Forgot password?',
    'no_account'          => 'Don\'t have an account?',
    'login_error'         => 'Invalid email or password.',
    'session_expired'     => 'Session expired. Please sign in again.',
    'logged_out'          => 'Successfully signed out.',

    'reg_title'           => 'Register Denomination',
    'reg_subtitle'        => 'Create your denomination account for free',
    'church_name'         => 'Denomination Name',
    'church_name_ph'      => 'e.g. Evangelical Church of Mozambique',
    'admin_name'          => 'Administrator Name',
    'country'             => 'Country',
    'province'            => 'Province / State',
    'district'            => 'District / City',
    'admin_email'         => 'Administrator Email',
    'admin_pass'          => 'Password',
    'confirm_pass'        => 'Confirm Password',
    'pass_hint'           => 'Min 6 chars: letters, numbers and symbol (e.g. Church#1)',
    'reg_btn'             => 'Create Free Account',
    'already_account'     => 'Already have an account?',
    'trial_info'          => '✅ 6 months free — No credit card required',
    'reg_success'         => 'Denomination registered! You can now sign in.',
    'err_required'        => 'Please fill in all required fields.',
    'err_email'           => 'Invalid email address.',
    'err_pass_match'      => 'Passwords do not match.',
    'err_pass_weak'       => 'Password must have at least 6 characters, one letter, one number and one symbol.',
    'err_email_used'      => 'This email is already in use.',

    'total_members'       => 'Total Members',
    'active_members'      => 'Active',
    'cut_members'         => 'Suspended',
    'unlinked_members'    => 'Unlinked',
    'married'             => 'Married',
    'dating'              => 'Dating',
    'new_this_month'      => 'New This Month',
    'subdivisions'        => 'Subdivisions',
    'leaders'             => 'Leaders',
    'members'             => 'Members',
    'add_member'          => '＋ New Member',
    'all_statuses'        => 'All statuses',
    'all_subs'            => 'All subdivisions',
    'blacklist'           => 'Blacklist',
    'restore'             => '♻️ Restore',
    'recent_members'      => 'Recent Members',
    'view_all'            => 'View All →',

    'trial_active'        => 'Trial Period',
    'trial_days_left'     => '{{days}} days remaining',
    'trial_expired'       => 'Trial Period Expired',
    'license_active'      => 'License Active',
    'license_expires'     => 'Expires on {{date}}',
    'upgrade_now'         => 'Get License',
    'contact_admin'       => 'Contact Administrator',

    'nav_dashboard'       => 'Dashboard',
    'nav_setup'           => 'Denominations & Subdivisions',
    'nav_users'           => 'Users',
    'nav_members'         => 'Members',
    'nav_ministries'      => 'Ministries',
    'nav_leaders'         => 'Leaders',
    'nav_finance'         => 'Finance',
    'nav_reports'         => 'Reports',
    'nav_public'          => 'Public Page',
    'nav_churches'        => 'Denominations',
    'nav_licenses'        => 'Licenses',

    'super_admin_title'   => 'General Administrator',
    'churches_registered' => 'Registered Denominations',
    'gen_key'             => 'Generate Key',
    'key_1yr'             => '1 Year ($10)',
    'key_2yr'             => '2 Years ($15)',
    'key_3yr'             => '3 Years ($20)',
    'key_trial'           => 'Trial (+6 months)',
    'delete_church'       => 'Delete Denomination',
    'confirm_delete'      => 'Are you sure you want to delete this denomination? This action cannot be undone.',

    'cookie_msg'          => 'We use cookies to improve your experience. By continuing, you accept our ',
    'cookie_policy'       => 'Cookie Policy',
    'privacy_policy'      => 'Privacy Policy',
    'cookie_accept'       => 'Accept',
    'cookie_decline'      => 'Decline',
];

$LANG = ($lang === 'en') ? $LANG_EN : $LANG_PT;
