<?php
// ═══════════════════════════════════════════════════════════════
//  EKLESIA STANDALONE — index.php (Login)
// ═══════════════════════════════════════════════════════════════
define('DEPTH', 0);
require_once __DIR__ . '/includes/config.php';

// Guardar redirect antes de verificar activação
if (!isActivated()) { header('Location: activate.php'); exit; }
$sys = json_decode(file_get_contents(SYSTEM_FILE), true) ?? [];
if (empty($sys['installed'])) { header('Location: install.php'); exit; }

if (isLoggedIn()) {
    $role = currentUser()['role'];
    if ($role === 'finance_user') { header('Location: finance/'); exit; }
    if ($role === 'local_user')   { header('Location: local/');   exit; }
    header('Location: church/'); exit;
}

$lang   = getLang();
$church = $sys['church_name'] ?? 'Eklesia';
$error  = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = strtolower(trim($_POST['email'] ?? ''));
    $pass  = trim($_POST['password'] ?? '');

    // Verificar admin principal
    $admin = $sys['admin'] ?? [];
    if ($email === ($admin['email'] ?? '') && password_verify($pass, $admin['password'] ?? '')) {
        $_SESSION['eklesia_user'] = [
            'id'        => 'usr-admin',
            'name'      => $admin['name'],
            'email'     => $admin['email'],
            'role'      => 'admin',
            'church_id' => 'main'
        ];
        header('Location: church/'); exit;
    }

    // Verificar utilizadores adicionais
    $usersFile = CHURCHES_DIR . '/main/users.json';
    if (file_exists($usersFile)) {
        $usersData = json_decode(file_get_contents($usersFile), true) ?? [];
        foreach ($usersData['users'] ?? [] as $u) {
            if ($email === ($u['email'] ?? '') && password_verify($pass, $u['password'] ?? '')) {
                $_SESSION['eklesia_user'] = [
                    'id'             => $u['id'],
                    'name'           => $u['name'],
                    'email'          => $u['email'],
                    'role'           => $u['role'],
                    'church_id'      => 'main',
                    'subdivision_id' => $u['subdivision_id'] ?? null
                ];
                if ($u['role'] === 'finance_user') { header('Location: finance/'); exit; }
                if ($u['role'] === 'local_user')   { header('Location: local/');   exit; }
                header('Location: church/'); exit;
            }
        }
    }

    $error = $lang==='en' ? 'Invalid email or password.' : 'Email ou senha incorrectos.';
}
?>
<!DOCTYPE html>
<html lang="<?= $lang==='en'?'en':'pt' ?>">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<meta name="robots" content="noindex,nofollow">
<title><?= htmlspecialchars($lang==='en'?'Login':'Entrar') ?> — <?= htmlspecialchars($church) ?></title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link href="https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital,wght@0,400;0,600;0,700;1,400&family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="assets/css/style.css">
<style>
.login-page{min-height:100vh;display:grid;grid-template-columns:1fr 420px;background:var(--navy)}
.login-brand{display:flex;flex-direction:column;justify-content:center;align-items:center;gap:.75rem;padding:3rem;background:linear-gradient(160deg,var(--navy-mid),var(--navy));position:relative;overflow:hidden}
.login-brand::before{content:'';position:absolute;width:420px;height:420px;border:1px solid rgba(201,168,76,.1);border-radius:50%;top:50%;left:50%;transform:translate(-50%,-50%);pointer-events:none}
.brand-cross-wrap{font-size:3rem;color:var(--gold);position:relative;z-index:1}
.brand-name{font-family:'Cormorant Garamond',serif;font-size:3rem;font-weight:700;color:var(--gold);letter-spacing:3px;text-transform:uppercase;position:relative;z-index:1;text-align:center}
.brand-sub{color:rgba(255,255,255,.35);font-size:.78rem;letter-spacing:1.5px;text-transform:uppercase;position:relative;z-index:1;text-align:center}
.login-form-wrap{display:flex;flex-direction:column;justify-content:center;padding:3rem 2.5rem;background:var(--page-bg)}
.login-card h2{font-size:1.8rem;color:var(--navy);margin-bottom:.3rem}
.login-card .sub{color:var(--text-muted);font-size:.85rem;margin-bottom:1.75rem}
@media(max-width:768px){.login-page{grid-template-columns:1fr}.login-brand{display:none}.login-form-wrap{padding:2rem 1.5rem}}
</style>
</head>
<body>
<div class="login-page">
    <div class="login-brand">
        <div class="brand-cross-wrap">✝</div>
        <div class="brand-name"><?= htmlspecialchars(mb_strtoupper(mb_substr($church,0,10))) ?></div>
        <div class="brand-sub"><?= htmlspecialchars($church) ?></div>
        <div style="color:rgba(255,255,255,.18);font-size:.68rem;margin-top:2rem;position:relative;z-index:1">
            Powered by <a href="https://eklesia.asaf.fyi" target="_blank" style="color:var(--gold);opacity:.6">eklesia.asaf.fyi</a>
        </div>
    </div>
    <div class="login-form-wrap">
        <div class="login-card">
            <h2><?= $lang==='en'?'Welcome back':'Bem-vindo de volta' ?></h2>
            <p class="sub"><?= $lang==='en'?'Sign in to your account':'Inicie sessão na sua conta' ?></p>

            <?php if ($error): ?>
            <div class="alert alert-danger">❌ <?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            <?php $f = getFlash(); if ($f): ?>
            <div class="alert alert-<?= $f['type'] === 'success' ? 'success' : 'info' ?>">
                <?= $f['type']==='success'?'✅':'ℹ️' ?> <?= $f['msg'] ?>
            </div>
            <?php endif; ?>

            <form method="POST">
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" required
                        placeholder="<?= $lang==='en'?'your@email.com':'o.seu@email.com' ?>"
                        value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" autofocus>
                </div>
                <div class="form-group">
                    <label><?= $lang==='en'?'Password':'Senha' ?></label>
                    <input type="password" name="password" class="form-control" required
                        placeholder="••••••••">
                </div>
                <button type="submit" class="btn btn-primary btn-full" style="margin-top:.5rem">
                    <?= $lang==='en'?'Sign In →':'Entrar →' ?>
                </button>
            </form>

            <div style="margin-top:1.5rem;text-align:center">
                <a href="?lang=<?= $lang==='en'?'pt':'en' ?>" style="font-size:.78rem;color:var(--text-muted)">
                    <?= $lang==='en'?'🌐 Português':'🌐 English' ?>
                </a>
            </div>
        </div>
    </div>
</div>
</body></html>
