<?php
// ═══════════════════════════════════════════════════════════════
//  EKLESIA STANDALONE — install.php
//  Wizard de configuração inicial (nome da igreja + admin)
// ═══════════════════════════════════════════════════════════════
define('DEPTH', 0);
require_once __DIR__ . '/includes/config.php';

// Verificar activação
if (!isActivated()) { header('Location: activate.php'); exit; }

// Se já instalado, ir para login
$sys = json_decode(file_get_contents(SYSTEM_FILE), true) ?? [];
if (!empty($sys['installed'])) { header('Location: index.php'); exit; }

$lang  = getLang();
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $churchName = trim($_POST['church_name'] ?? '');
    $adminName  = trim($_POST['admin_name']  ?? '');
    $adminEmail = strtolower(trim($_POST['admin_email'] ?? ''));
    $adminPass  = trim($_POST['admin_pass']  ?? '');
    $adminPass2 = trim($_POST['admin_pass2'] ?? '');

    if (!$churchName || !$adminName || !$adminEmail || !$adminPass) {
        $error = $lang==='en' ? 'All fields are required.' : 'Todos os campos são obrigatórios.';
    } elseif (!filter_var($adminEmail, FILTER_VALIDATE_EMAIL)) {
        $error = $lang==='en' ? 'Invalid email.' : 'Email inválido.';
    } elseif (strlen($adminPass) < 6) {
        $error = $lang==='en' ? 'Password must have at least 6 characters.' : 'A senha deve ter pelo menos 6 caracteres.';
    } elseif ($adminPass !== $adminPass2) {
        $error = $lang==='en' ? 'Passwords do not match.' : 'As senhas não coincidem.';
    } else {
        // Guardar sistema
        $system = [
            'church_name' => $churchName,
            'country'     => trim($_POST['country'] ?? ''),
            'admin' => [
                'id'         => 'usr-admin',
                'name'       => $adminName,
                'email'      => $adminEmail,
                'password'   => password_hash($adminPass, PASSWORD_DEFAULT),
                'role'       => 'admin',
                'created_at' => date('Y-m-d H:i:s')
            ],
            'installed'    => true,
            'installed_at' => date('Y-m-d H:i:s')
        ];
        file_put_contents(SYSTEM_FILE, json_encode($system, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

        // Criar estrutura de subdivisões e utilizadores
        $churchDir = CHURCHES_DIR . '/main';
        if (!is_dir($churchDir)) mkdir($churchDir, 0755, true);

        // Criar ficheiros de dados base
        foreach (['members','subdivisions','ministries','leaders','finances','users','blacklist'] as $f) {
            $fp = $churchDir . "/{$f}.json";
            if (!file_exists($fp)) {
                $default = match($f) {
                    'members'      => ['members' => []],
                    'subdivisions' => ['subdivisions' => []],
                    'ministries'   => ['ministries' => []],
                    'leaders'      => ['leaders' => []],
                    'finances'     => ['categories' => [], 'transactions' => []],
                    'users'        => ['users' => []],
                    'blacklist'    => ['members' => []],
                };
                file_put_contents($fp, json_encode($default, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
            }
        }

        $msg = $lang==='en' ? 'Installation complete! Please log in.' : 'Instalação concluída! Faça login.';
        flashMessage('success', $msg);
        header('Location: index.php');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="<?= $lang==='en'?'en':'pt' ?>">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<meta name="robots" content="noindex,nofollow">
<title><?= $lang==='en'?'Setup — Eklesia':'Configuração — Eklesia' ?></title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link href="https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital,wght@0,400;0,600;0,700;1,400&family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="assets/css/style.css">
<style>
.install-page{min-height:100vh;background:var(--page-bg);display:flex;align-items:flex-start;justify-content:center;padding:3rem 1.5rem}
.install-wrap{width:100%;max-width:540px}
.install-header{text-align:center;margin-bottom:2rem}
.install-logo{font-family:'Cormorant Garamond',serif;font-size:2.2rem;font-weight:700;color:var(--navy);letter-spacing:2px}
.install-step{display:flex;align-items:center;gap:.6rem;justify-content:center;margin-top:.5rem;font-size:.78rem;color:var(--text-muted);text-transform:uppercase;letter-spacing:.08em}
.install-step span{background:var(--gold);color:var(--navy);width:20px;height:20px;border-radius:50%;display:flex;align-items:center;justify-content:center;font-weight:700;font-size:.7rem}
.section-label{font-size:.72rem;font-weight:700;text-transform:uppercase;letter-spacing:.1em;color:var(--text-muted);padding:.75rem 0 .3rem;border-bottom:1px solid var(--border);margin-bottom:1rem}
</style>
</head>
<body>
<div class="install-page">
    <div class="install-wrap">
        <div class="install-header">
            <div style="font-size:2.5rem;margin-bottom:.5rem">✝</div>
            <div class="install-logo">EKLESIA</div>
            <div class="install-step"><span>2</span><?= $lang==='en'?'Initial Configuration':'Configuração Inicial' ?></div>
        </div>

        <?php if ($error): ?>
        <div class="alert alert-danger">❌ <?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">⛪ <?= $lang==='en'?'Set up your denomination':'Configurar a sua denominação' ?></h3>
            </div>
            <div class="card-body">
                <form method="POST">
                    <div class="section-label">🏛️ <?= $lang==='en'?'Denomination Information':'Informação da Denominação' ?></div>
                    <div class="form-group">
                        <label><?= $lang==='en'?'Denomination Name':'Nome da Denominação' ?> <span class="req">*</span></label>
                        <input type="text" name="church_name" class="form-control" required
                            placeholder="<?= $lang==='en'?'E.g. First Baptist Church':'Ex: Igreja Baptista Central' ?>"
                            value="<?= htmlspecialchars($_POST['church_name'] ?? '') ?>">
                    </div>
                    <div class="form-group">
                        <label><?= $lang==='en'?'Country':'País' ?></label>
                        <input type="text" name="country" class="form-control"
                            placeholder="<?= $lang==='en'?'Mozambique':'Moçambique' ?>"
                            value="<?= htmlspecialchars($_POST['country'] ?? '') ?>">
                    </div>

                    <div class="section-label">👤 <?= $lang==='en'?'Administrator Account':'Conta de Administrador' ?></div>
                    <div class="form-group">
                        <label><?= $lang==='en'?'Your Name':'O seu nome' ?> <span class="req">*</span></label>
                        <input type="text" name="admin_name" class="form-control" required
                            value="<?= htmlspecialchars($_POST['admin_name'] ?? '') ?>">
                    </div>
                    <div class="form-group">
                        <label><?= $lang==='en'?'Administrator Email':'Email do Administrador' ?> <span class="req">*</span></label>
                        <input type="email" name="admin_email" class="form-control" required
                            placeholder="pastor@minhaigreja.com"
                            value="<?= htmlspecialchars($_POST['admin_email'] ?? '') ?>">
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label><?= $lang==='en'?'Password':'Senha' ?> <span class="req">*</span></label>
                            <input type="password" name="admin_pass" class="form-control" required
                                placeholder="<?= $lang==='en'?'Min. 6 characters':'Mín. 6 caracteres' ?>">
                        </div>
                        <div class="form-group">
                            <label><?= $lang==='en'?'Confirm Password':'Confirmar Senha' ?> <span class="req">*</span></label>
                            <input type="password" name="admin_pass2" class="form-control" required>
                        </div>
                    </div>

                    <div class="alert alert-info" style="font-size:.82rem">
                        ℹ️ <?= $lang==='en'
                            ? 'These are the main administrator credentials. Keep them in a safe place.'
                            : 'Estas são as credenciais do administrador principal. Guarde-as num lugar seguro.' ?>
                    </div>

                    <button type="submit" class="btn btn-primary btn-full btn-lg">
                        <?= $lang==='en'?'✅ Complete Installation':'✅ Concluir Instalação' ?>
                    </button>
                </form>
            </div>
        </div>

        <div style="text-align:center;margin-top:1.25rem;font-size:.72rem;color:var(--text-muted)">
            <a href="?lang=<?= $lang==='en'?'pt':'en' ?>" style="color:var(--text-muted)">
                <?= $lang==='en'?'🌐 Português':'🌐 English' ?>
            </a>
            &nbsp;·&nbsp;
            Powered by <a href="https://eklesia.asaf.fyi" target="_blank" style="color:var(--gold)">eklesia.asaf.fyi</a>
        </div>
    </div>
</div>
</body></html>
