<?php
define('DEPTH', 1);
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/layout.php';

if (!isActivated()) { header('Location: ../activate.php'); exit; }
$user = currentUser();
if (!$user || $user['role'] !== 'local_user') { header('Location: ../index.php'); exit; }

$lang     = getLang();
$churchId = 'main';
$subId    = $user['subdivision_id'] ?? null;
$allM     = getChurchMembers($churchId);
$members  = $subId
    ? array_filter($allM['members'] ?? [], fn($m) => ($m['subdivision_id'] ?? null) === $subId)
    : ($allM['members'] ?? []);

$active    = array_filter($members, fn($m) => ($m['status'] ?? '') === 'active');
$suspended = array_filter($members, fn($m) => ($m['status'] ?? '') === 'suspended');
$subName   = getSubdivisionName($churchId, $subId);

renderHead($lang==='en'?'Local Dashboard':'Painel Local');
?>
<body>
<?php renderSidebar('local_user'); ?>
<div class="main-content">
    <div class="topbar">
        <div style="display:flex;align-items:center;gap:1rem">
            <button class="hamburger" onclick="toggleSidebar()"><span></span><span></span><span></span></button>
            <div>
                <div class="topbar-title"><?= $lang==='en'?'Local Dashboard':'Painel Local' ?></div>
                <div class="topbar-sub"><?= htmlspecialchars($subName ?: ($lang==='en'?'All congregations':'Todas as congregações')) ?></div>
            </div>
        </div>
    </div>
    <div class="page-content">
        <?php renderSuggestionBanner(); ?>
        <?php renderFlash(); ?>
        <div class="stats-grid">
            <div class="stat-card"><div class="stat-icon">👥</div><div class="stat-info"><div class="stat-value"><?= count($members) ?></div><div class="stat-label"><?= $lang==='en'?'Total':'Total' ?></div></div></div>
            <div class="stat-card"><div class="stat-icon">✅</div><div class="stat-info"><div class="stat-value" style="color:var(--success)"><?= count($active) ?></div><div class="stat-label"><?= $lang==='en'?'Active':'Activos' ?></div></div></div>
            <div class="stat-card"><div class="stat-icon">⚠️</div><div class="stat-info"><div class="stat-value" style="color:var(--warning-c)"><?= count($suspended) ?></div><div class="stat-label"><?= $lang==='en'?'Suspended':'Cortados' ?></div></div></div>
        </div>
        <div style="margin-top:1rem;display:flex;gap:.75rem;flex-wrap:wrap">
            <a href="../local/members.php" class="btn btn-primary">👥 <?= $lang==='en'?'View Members':'Ver Membros' ?></a>
            <a href="../local/members.php?action=new" class="btn btn-outline">＋ <?= $lang==='en'?'New Member':'Novo Membro' ?></a>
            <a href="../local/reports.php" class="btn btn-outline">📊 <?= $lang==='en'?'Reports':'Relatórios' ?></a>
        </div>
    </div>
    <?php renderFooter(); ?>
</div>
<?php renderJS(); ?>
