<?php
define('DEPTH', 1);
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';
$user = currentUser();
if (!$user || $user['role'] !== 'local_user') { header('Location: ../index.php'); exit; }

$churchId = 'main';
$subId    = $user['subdivision_id'] ?? null;
$church   = getChurchInfo($churchId);
$subName  = $subId ? getSubdivisionName($churchId, $subId) : 'Todos';

$membersData = getMembers($churchId);
$allM = $membersData['members'];
if ($subId) $allM = array_values(array_filter($allM, fn($m) => ($m['subdivision_id']??'') === $subId));

$activos      = array_values(array_filter($allM, fn($m) => $m['status']==='activo'));
$cortados     = array_values(array_filter($allM, fn($m) => $m['status']==='cortado'));
$desvinc      = array_values(array_filter($allM, fn($m) => $m['status']==='desvinculado'));
$casados      = array_values(array_filter($allM, fn($m) => ($m['marital_status']??'') === 'casado'));
$solteiros    = array_values(array_filter($allM, fn($m) => ($m['marital_status']??'') === 'solteiro'));
$namorando    = array_values(array_filter($allM, fn($m) => !empty($m['dating_with'])));

// Membros novos este mês
$thisMonth = date('Y-m');
$newThisMonth = array_values(array_filter($allM, fn($m) => str_starts_with($m['created_at']??'', $thisMonth)));

renderHead('Relatório Local — ' . $church['name']);
?>
<body>
<?php renderSidebar($user['role']); ?>
<div class="main-content">
    <div class="topbar">
        <div style="display:flex;align-items:center;gap:.85rem"><button class="hamburger" onclick="toggleSidebar()"><span></span><span></span><span></span></button><div><div class="topbar-title">Relatório Local</div><div class="topbar-sub"><?= sanitize($subName) ?></div></div></div>
        <div class="topbar-actions"><button onclick="window.print()" class="btn btn-outline btn-sm">🖨️ Imprimir</button></div>
    </div>
    <div class="page-content">
        <?php renderSuggestionBanner(); ?>
        <div class="card" style="margin-bottom:1.5rem">
            <div class="card-header"><h3 class="card-title">📊 Resumo Geral — <?= sanitize($subName) ?></h3></div>
            <div class="stats-grid" style="grid-template-columns:repeat(3,1fr);padding:1.5rem">
                <div class="stat-card"><div class="stat-icon">👥</div><div class="stat-info"><div class="stat-value"><?= count($allM) ?></div><div class="stat-label">Total de Membros</div></div></div>
                <div class="stat-card"><div class="stat-icon" style="color:#22c55e">✅</div><div class="stat-info"><div class="stat-value" style="color:#22c55e"><?= count($activos) ?></div><div class="stat-label">Activos</div></div></div>
                <div class="stat-card"><div class="stat-icon" style="color:#f59e0b">⚠️</div><div class="stat-info"><div class="stat-value" style="color:#f59e0b"><?= count($cortados) ?></div><div class="stat-label">Cortados</div></div></div>
                <div class="stat-card"><div class="stat-icon" style="color:#ef4444">🚫</div><div class="stat-info"><div class="stat-value" style="color:#ef4444"><?= count($desvinc) ?></div><div class="stat-label">Desvinculados</div></div></div>
                <div class="stat-card"><div class="stat-icon">💍</div><div class="stat-info"><div class="stat-value"><?= count($casados) ?></div><div class="stat-label">Casados</div></div></div>
                <div class="stat-card"><div class="stat-icon">💑</div><div class="stat-info"><div class="stat-value"><?= count($namorando) ?></div><div class="stat-label">Em Namoro</div></div></div>
            </div>
        </div>

        <?php if (!empty($newThisMonth)): ?>
        <div class="card">
            <div class="card-header"><h3 class="card-title">🆕 Novos Membros Este Mês</h3><span class="badge badge-success"><?= count($newThisMonth) ?></span></div>
            <div class="table-wrap">
                <table><thead><tr><th>Nome</th><th>Baptismo</th><th>Estado</th></tr></thead><tbody>
                <?php foreach ($newThisMonth as $m): ?>
                <tr>
                    <td><strong><?= sanitize($m['name']) ?></strong></td>
                    <td class="text-sm text-muted"><?= $m['baptism_date'] ? date('d/m/Y', strtotime($m['baptism_date'])) : '—' ?></td>
                    <td><span class="badge <?= statusBadge($m['status']) ?>"><?= statusLabel($m['status']) ?></span></td>
                </tr>
                <?php endforeach; ?>
                </tbody></table>
            </div>
        </div>
        <?php endif; ?>

        <?php if (!empty($cortados)): ?>
        <div class="card">
            <div class="card-header"><h3 class="card-title">🔶 Membros Cortados</h3><span class="badge badge-warning"><?= count($cortados) ?></span></div>
            <div class="table-wrap">
                <table><thead><tr><th>Nome</th><th>Motivo</th><th>Nº Cortes</th></tr></thead><tbody>
                <?php foreach ($cortados as $m):
                    $cuts = count(array_filter($m['cut_history']??[], fn($h) => $h['type']==='cortado')); ?>
                <tr>
                    <td><strong><?= sanitize($m['name']) ?></strong></td>
                    <td class="text-sm text-muted"><?= sanitize($m['status_reason'] ?? '—') ?></td>
                    <td><span class="badge badge-warning"><?= $cuts ?>×</span></td>
                </tr>
                <?php endforeach; ?>
                </tbody></table>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php renderFooter(); ?>
<?php renderJS(); ?></body></html>
